##############################################################
# Area related functions and defs:
#   read from .yaml files
#   calculate ran
#   divide area's in regio's
# Hilversum   , 2022/11/01       License GPL3          (c) Rob Alblas
#
############################################################################################

from satpy_settings import regio_list
import re
import math

class carea:
  def __init__(self):
    self.head=None
    self.next=None
    self.name=None
    self.lat=None
    self.lon=None
    self.ran=None
    self.llx=None
    self.lly=None
    self.urx=None
    self.ury=None

class cregio:
  def __init__(self):
    self.head=None
    self.next=None
    self.name=None
    self.area=carea()


#######################################################
# Parse related funcs for .yaml-file
#######################################################
# parse .yaml-file: check start-of-area description
def is_new_area(ln):
  sln=ln.split()
  if sln!=[] and sln[0][len(sln[0])-1:] == ':' and ln[0]!=' ':
    return True
  else:
    return False

# start part intended column 2
def is_start2(ln,x):
  y='  '+x+':'
  if ln[:len(y)] ==y:
    return True
  else:
    return False

# end part intended column 2
def is_end2(ln):
  if len(ln)>2 and ln[2]!=' ':
    return True
  else:
    return False


def add_area(areas,name,lat=None,lon=None,ran=None,llx=None,lly=None,urx=None,ury=None):
  global parea
  a=carea()
  a.name=name
  a.lat=lat
  a.lon=lon
  a.ran=ran
  a.llx=llx
  a.lly=lly
  a.urx=urx
  a.ury=ury

  if (areas.head==None):
    areas.head=a
  else:
    p=areas.head
    while p is not None:
      if p.next==None:
        p.next=a
        break
      p=p.next
  return a

#Next partly 'stolen' from LEOstuff.py
def arc_dist(lon, lat, clon, clat):
    # Degrees to radian
    dr = math.pi/180.0
    sinlat = math.sin(lat*dr)
    coslat = math.cos(lat*dr)
    # Use Nautical Triangle, return arc distance from center of map (POI) to corners in degrees
    cosarc = sinlat * math.sin(clat*dr) +  \
             coslat * math.cos(clat*dr) * math.cos((lon-clon)*dr)
    return math.acos(cosarc)/dr

def calc_ran(areas):
  a=areas.head
  dr=math.pi/180.
  while a is not None:
    if a.lat==None or a.lon==None:
      a=a.next
      continue

    #Hm, probably not 100% correct...
    w=abs(a.llx-a.urx)
    h=abs(a.lly-a.ury)
    dlat=h/40000000.*360.
    if a.lat<0:
      abslatmin=a.lat+dlat/2
      if abslatmin>0:
        abslatmin=0
    else:
      abslatmin=a.lat-dlat/2
      if abslatmin<0:
        abslatmin=0

    dlon=(w*math.cos(dr*abslatmin))/40000000.*360.

    fac = 1.5
    d1 = fac * arc_dist(a.lon, a.lat, a.lon-dlon/2,a.lat-dlat/2)
    d2 = fac * arc_dist(a.lon, a.lat, a.lon-dlon/2,a.lat+dlat/2)
    d3 = fac * arc_dist(a.lon, a.lat, a.lon+dlon/2,a.lat-dlat/2)
    d4 = fac * arc_dist(a.lon, a.lat, a.lon+dlon/2,a.lat+dlat/2)
    ran1=min(50.0, max(d1, d2, d3, d4, 10.0))
    a.ran=abs(math.ceil(ran1))
    a=a.next


# collect all areas from .yaml files
#   Return: 2D-list, [areaname,lat=float,lon=float]
def collect_all_areas():
  from satpy.resample import get_area_file
  areafiles=get_area_file()
  areas=carea()

  areaname=None
  lon=None
  lat=None
  ran=None
  llx=None
  lly=None
  urx=None
  ury=None
  nr=0
  for fs in areafiles:         # all area files (.yaml)
    print('  Read areas from '+fs)
    with open(fs) as f:
      projection=False
      area_extent=False
#      for line in f:           # parse line by line
      for line in iter(f.readline,''):           # parse line by line
        ln=line.strip('\n')
#        print(ln)
        if is_new_area(ln):    # check: start-of-new area
          if areaname != None:
            add_area(areas,areaname,lat,lon,ran,llx,lly,urx,ury)

          projection=False
          area_extent=False
          lon=None
          lat=None
          ln=ln.split(':')
          areaname=ln[0]

          dubbel=False
          p=areas.head
          while p is not None:
            if p.name == areaname:
#              print('DUBBEL: '+p.name+' lat='+str(p.lat))
              dubbel=True
              break
            p=p.next
          if dubbel:
            areaname = None
            continue

        if is_start2(ln,'projection'):
          projection=True
        elif is_end2(ln):
          projection=False

        if is_start2(ln,'area_extent'):
          area_extent=True
        elif is_end2(ln):
          area_extent=False

        if projection: # catch central position
          sln=ln.split()
          # detection pos
          if sln:
            if sln[0]=='lat_0:':
              lat=float(sln[1])
            if sln[0]=='lon_0:':
              lon=float(sln[1])

        if area_extent: # catch central position
          sln=re.split(r'[\[\]\s,]+',ln)
          if len(sln) >1:
            if sln[1]=='lower_left_xy:':
              llx=float(sln[2])
              lly=float(sln[3])
            if sln[1]=='upper_right_xy:':
              urx=float(sln[2])
              ury=float(sln[3])

    # Add the last one
    if areaname != None:
      add_area(areas,areaname,lat,lon,ran,llx,lly,urx,ury)

  calc_ran(areas)
  return areas
# test if lat/lon is in regio 'regioname'
#     return regio if so, or 'None'
def in_regio(regio_list,regioname,lat,lon):
  if regioname!='rest':
    for regio in regio_list:
      if regio[0]==regioname:
        if lat>=regio[1][0] and lat <= regio[2][0] and \
          lon>=regio[1][1] and lon <= regio[2][1]:
          return True
        else:
          return False
  else:
    for regio in regio_list:
      if regio[0]!='rest':
        if lat>=regio[1][0] and lat <= regio[2][0] and \
           lon>=regio[1][1] and lon <= regio[2][1]:
          return False
      else:
        return regio
  return None

def add_regio(regios,name):
  global pregio
  r=cregio()
  r.name=name

  if (regios.head==None):
    regios.head=r
  else:
    p=regios.head
    while p is not None:
      if p.next==None:
        p.next=r
        break
      p=p.next
  return r


# create structured areaset: areas as from *.yaml files 
#    grouped under regio_list:
#   regio1 -> area1a -> area1b.....
#     |
#     V
#   regio2 -> area2a -> area2b.....
#     |
#     V
#   regio3 -> area3a -> area3b.....
#   ....
# return:
def create_regioarea(regio_list,areas):
  regios=cregio()
  parea=None
  r=add_regio(regios,'default')
  add_area(r.area,'default')
  r=add_regio(regios,'swath')
  add_area(r.area,'swath')
  for regio in regio_list:                         # regio=[regiox,(lat1,lon1),(lat2,lon2)]
    r=add_regio(regios,regio[0])
    p=areas.head
    while p is not None:
      if p.lat!=None and p.lon!=None:
        if in_regio(regio_list,regio[0],p.lat,p.lon): # test area in box of area[0]
          add_area(r.area,p.name,p.lat,p.lon,p.ran)
      p=p.next

  return regios

def get_area_info(areaname):
  areas=collect_all_areas()
  p=areas.head
  while p is not None:
    if p.name==areaname:
      return p
    p=p.next
  return None
      

def list_areas(ar):
  p=ar.head
  while p is not None:
    print(p.name+'  '+str(p.lat)+'   '+str(p.lon)+'   '+str(p.ran)+'   '+str(p.llx)+'   '+str(p.lly)+'   ' +str(p.urx)+'   '+str(p.ury))
    p=p.next

def list_regios_areas(ra):
  p=ra.head
  while p is not None:
    print(p.name)
    q=p.area.head
    while q is not None:
      print('    '+str(q.name)+'  '+str(q.lat)+'   '+str(q.lon)+'   ran='+str(q.ran))
      q=q.next
    p=p.next

## Example use:
## info one area:
#a=get_area_info('westminster')
#print(str(a.name)+'  lat='+str(a.lat)+'   lon='+str(a.lon)+'   ran='+str(a.ran))

##  extracted info all area's
#a=collect_all_areas()
#list_areas(a)

##  collect area's per regio
#a=collect_all_areas()
#regios=create_regioarea(regio_list,a)
#list_regios_areas(regios)
