#!/usr/bin/env python3
####################################################################################
# satpy area visualizer
# Hilversum   , 2024/05/01       License GPL3          (c) Rob Alblas
####################################################################################

from satpy_settings import regio_list,earth_image
from satpy_areas import carea
from satpy_areas import is_new_area
from satpy_areas import create_regioarea
from satpy_areas import collect_all_areas


#############################################################
# gui part
#
import tkinter as tk
from tkinter import *
from PIL import ImageTk, Image

class ScrollableFrame(tk.Frame):
  def __init__(self, container, width=0,height=0, *args, **kwargs):
    super().__init__(container, *args, **kwargs)
    if height and width:
      canvas = tk.Canvas(self, height=height,width=width)
    elif width:
      canvas = tk.Canvas(self, width=width)
    elif height:
      canvas = tk.Canvas(self, height=height)
    else:
      canvas = tk.Canvas(self)

    if height:
      scrollbar_v = tk.Scrollbar(self, orient="vertical", command=canvas.yview)
    if width:
      scrollbar_h = tk.Scrollbar(self, orient="horizontal", command=canvas.xview)

    self.sframe = tk.Frame(canvas)

    self.sframe.bind(
      "<Configure>",
      lambda e: canvas.configure(
          scrollregion=canvas.bbox("all")
      )
    )

    canvas.create_window((0, 0), window=self.sframe, anchor="nw")

    if height:
      canvas.configure(yscrollcommand=scrollbar_v.set)
      scrollbar_v.pack(side="right", fill="y")

    if width:
      canvas.configure(xscrollcommand=scrollbar_h.set)
      scrollbar_h.pack(side="bottom", fill="x")

    canvas.pack(side="left", fill="both", expand=True)


cvsx=None
frame=None
#fact=2.5
def track_viewer(fn):
  global img # anders img opgeruimd na func!
  global cvsx
  global frame
  if fn==None:
    if frame:
      frame.destroy()
      frame=None
      cvsx=None
    return

  width=int(360*fact)
  height=int(180*fact)

  # create frame with canvas, or use existing one
  if cvsx==None:
    frame=Frame()
    cvsx = tk.Canvas(frame, bg="grey90", height=height, width=width)
    cvsx.grid()
    frame.pack()

  # clear canvas, then add background image again 
  if cvsx != None:
    cvsx.delete('all')
  try:
    img1=Image.open(fn)
  except:
    if frame:
      frame.destroy()
    frame=None
    cvsx=None

    print(fn+" doesn't exist.")
    return None,None,None

  img1=img1.resize((width,height))
  img = ImageTk.PhotoImage(img1)
  cvsx.create_image(0,0,image=img,anchor="nw")

  # Add lon/lat grid
  step=30 # degrees, lat and lon
  for lat in range(-90+step,90,step):
    cvsx.create_line(0,(lat+90)*fact,360*fact,(lat+90)*fact,width=1)
  for lon in range(0+step,360,step):
    cvsx.create_line(lon*fact,0,lon*fact,180*fact,width=1)

  return cvsx,width,height

from satpy.resample import get_area_def
from satpy.resample import get_area_file
import pyresample
#entry1=None
def draw_area(cvsx,sel_area,width,height):
  global entry1
  entry1.delete(0,'end')
  try:
    sarea=get_area_def(sel_area)
  except:
    entry1.insert(0,'No area "'+str(sel_area)+'" found.')
    return

  try:
    arr=pyresample.geometry.BaseDefinition.get_bbox_lonlats(sarea)
  except:
    entry1.insert(0,"Can't create bbox for "+str(sel_area))
    return

  lons=arr[0]
  lats=arr[1]
  m=0
  for lon in lons:
    lat=lats[m]
    n=0
    for lon1 in lon:
      if abs(lon1) > 1000:
        continue
      lat1=lat[n]
      if abs(lat1) > 1000:
        continue
      ilon=int((lon1+180)*fact)
      ilat=height-1-int((lat1+90)*fact)

      if n>0:
        if abs(lon1-plon1)<300:
          cvsx.create_line(ilon0, ilat0, ilon, ilat,width=1,fill=areaclr)
      plon1=lon1
      ilon0=ilon
      ilat0=ilat
      ilon0=ilon
      ilat0=ilat
      n+=1
    m+=1

def plot_area(sel_area=None):
  (cvsx,width,height)=track_viewer(earth_image)
  if cvsx==None:
    return

  if sel_area!=None:
    draw_area(cvsx,sel_area,width,height)
    return

# geeft vorige waarde...
def select_area():
  plot_area(sel_area.get())

def sel_xx():
  print(sel_area.get())
#  for p in regio_area:
#    for q in p.area:
#      print(str(q.name)+'  '+str(q.name))

def create_gui(regio_area):
  global sel_area,entry1
  wnd = tk.Tk()
  wnd.title('Satpy area visualizer')
  mcol=False

  # add canvas
  (cvsx,width,height)=track_viewer(earth_image)

  if use_buttons:
    x=1
    y=1
    sel_area = tk.StringVar(value="")
    frame0=ScrollableFrame(wnd,width,200)
    for p in regio_area:
      if p.area != None and p.name != 'default':
        frame1=Frame(frame0.sframe,highlightbackground="blue",highlightthickness=2)
        lab=tk.Label(frame1,text=p.name,anchor='nw').grid(column=x,row=0,sticky='W')
        for q in p.area:
  #        but=Checkbutton(frame1,text=q.name,command=sel_xx,variable=q.name,onvalue=1,anchor='nw').grid(column=x,row=y,sticky='W')
          but=Radiobutton(frame1,value=q.name,text=q.name,variable=sel_area,command=select_area,anchor='nw').grid(column=x,row=y,sticky='W')
          y+=1
          if mcol:
            if y>15:
              x+=1
              y=1
        x+=1
        y=1
        frame1.pack(side=tk.LEFT,anchor='nw')
  else:
    frame0=Frame(wnd)
    alabel=tk.Label(frame0,text='Area')
    sel_area = tk.StringVar(value="---")

    # make area menu
    amenubutton = tk.Menubutton(frame0, textvariable=sel_area, indicatoron=True,borderwidth=1, relief="raised")
    amenu = tk.Menu(amenubutton, tearoff=True)
    amenubutton.configure(menu=amenu)

    for p in regio_area:
      a_submenu = tk.Menu(amenu, tearoff=True)
      amenu.add_cascade(label=p.name, menu=a_submenu)
      for q in p.area:
        a_submenu.add_radiobutton(value=q.name, label=q.name, variable=sel_area,command=select_area)

    amenu=amenubutton

    # place area button
    alabel.grid(column=1,row=1)
    amenu.grid(column=1,row=2)
    frame0.pack(side=tk.TOP,anchor='w')

  frame0.pack(side=tk.TOP)

  frame2=Frame(wnd)
  entry1=Entry(frame2,font=('Arial', 12, 'bold'),width=40)
  entry1.grid()
  frame2.pack(side=tk.LEFT,anchor='sw')

  return wnd

import argparse
parser = argparse.ArgumentParser()
parser.add_argument('-s'        ,default=2.5            , help="size (multiplier fact.) image (1=org. size)")
parser.add_argument('-f'        ,default=earth_image    , help="plate carree image file")
parser.add_argument('-ac'       ,default='blue'         , help="colour area")
parser.add_argument('-m'        ,default=False,nargs='?',const=True , help="use menu instead of buttons")
args = parser.parse_args()

fact=float(args.s)
earth_image=args.f
areaclr=args.ac
use_buttons=not args.m

areas=collect_all_areas()
regio_area=create_regioarea(regio_list,areas)

wnd=create_gui(regio_area)
wnd.mainloop()
