#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# NOTE: Test! Not checked with real data yet!
# USAGE: MTI.py -sat [1,2,3,4] -t YYYYmmddHHMM, where dd=01..31, HH=00..23, MM=...
#************************************************************************
#
# European geostationary satellite Meteosat-12 (MTI1) at 0.0 degrees East
#------------------------------------------------------------------------
# Meteosat Third Generation Imager, MTI-1                              sensor 'fci'
#
# Channel | vis_04 | vis_05 | vis_06 | vis_08 | vis_09 | nir_13 | nir_16 | nir_22 |
# WaveLen |  0.444 |  0.510 |  0.640 |  0.865 |  0.914 |  1.380 |  1.610 |  2.250 |
# --------+--------+--------+--------+--------+--------+--------+--------+--------+
# Channel |  ir_38 |  wv_63 |  wv_73 |  ir_87 |  ir_97 | ir_105 | ir_123 | ir_133 |
# WaveLen |  3.800 |  6.300 |  7.350 |  8.700 |  9.660 | 10.500 | 12.300 | 13.300 |
#
# CH-3123 Belp, 2022/12/10            License GPL3               (c) Ernst Lobsiger
#    Hilversum, 2023/01/31       License GPL3          (c) Rob Alblas
#
#************************************************************************
#
# Typical naming of MSG4 channel data files (channel WV_062 segment 5 below)
# File pattern : {rate:1s}-000-{hrit_format:_<6s}-{platform_shortname:4s}_{service:_<7s}-WV_062___-{segment:06d}___-{start_time:%Y%m%d%H%M}-__
# Example name : H-000-MSG4__-MSG4________-WV_062___-000005___-202204070215-C_
# Hugo's ruler : 0123456789012345678901234567890123456789012345678901234567890
# copied EMCV  : 0         1         2         3         4         5         6
# EUMETCast    : These files arrive as above in channel E1B-GEO-3 (Basic)
# ANNOTATION   : This script uses ImageMagick (IM) convert for annotation


# I need
import os, sys, platform
from GEOstuff import test_argv, geo_images, get_magick
from GEO_extrastuff import get_args_geo,split_Dat,recreate_cmd, \
                           test_file_exist,create_dir, resize_image,\
                           satpy_viewer
# Why to hell is it not working?
# from satpy.utils import debug_on
# debug_on()

# What you should know
OS = platform.system()
# Minimal command line parameter test

opts = get_args_geo('MTI')

Yea, Mon, Day, Hou, Min=split_Dat(opts.Date)

sat='MTI'+str(opts.sat[0])

if sat=='MTI1':
  chan='E2H-MTG-1'
else:
  chan='unk'

curdir=os.getcwd()

# vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
# ********** ADAPT THESE PARAMETERS TO YOUR PERSONAL NEEDS ***********

# Edit 0-6 parameter(s) below according to your file layout:
# My files are in a /MountPoint/Channel/YYYY/mm/DD structure
# My files are compressed as received Christian decompresses
# Your segdir may be named differently from EUMETSAT channel
# No trailing / because this will make timestamps unreadable

if opts.src != '':
  segdir = opts.src
  if segdir[-1]=='/':
    segdir=segdir[:-1]
else:
  if OS == 'Linux':
      segdir = '/srv/'+chan
  elif OS == 'Windows':
      segdir = 'Z:/'+chan
  else:
      sys.exit('Sorry, OS ' + OS + ' seems unsupported yet ...')

if opts.bulk==None:      # use default value
  isbulk = True
else:
  isbulk = opts.bulk
decomp = False

# Your TC receiver type
receiver = 'SR1'

# Output of global_scene.available_composite_names() when all FCI channels are loaded:
# ***********************************************************************************
# ['airmass', 'ash', 'cimss_cloud_type', 'cimss_cloud_type_raw', 'cloud_phase', 'cloud_phase_distinction',
#  'cloud_phase_distinction_raw', 'cloud_phase_raw', 'cloudtop', 'convection', 'day_microphysics', 'dust',
#  'fog', 'green_snow', 'ir108_3d', 'ir_cloud_day', 'natural_color', 'natural_color_raw',
#  'natural_with_night_fog', 'night_fog', 'night_microphysics', 'true_color_raw']

# Choose one or more composites from the list above:
# (Your own personal composites should work as well)
# You can set composites = allcomposites if you dare

# This is now a list of composites and not a string (a single entry 'ash' must be written as ['ash'])
if opts.composites=='':
  composites = ['natural_color']
else:
  composites=opts.composites.split(',')

if opts.area=='':
  area = 'westminster'
else:
  area=opts.area

print('Area     : '+str(area))
print('Composite: '+str(composites))

# Optionally you can define an area dependant cities-list. If empty a sat default cities-list is used.
# Be aware that adding one city name will change your OVRcache even if the city is outside your image.
area_cities = []

# Configure your individual overlay components, either True/False or 1/0 do work
# The order below is how these components are drawn from the bottom to top layer

if opts.default:               # default overlays, no -ovl option
  ADDcoasts  = True
  ADDborders = True
  ADDrivers  = True
  ADDlakes   = True
  ADDgrid    = True
  ADDcities  = True
  ADDpoints  = True
  ADDstation = True
  ADDlegend  = True
else:                          # take overlays from option -ovl
  ADDcoasts  = opts.coasts
  ADDborders = opts.borders
  ADDrivers  = opts.rivers
  ADDlakes   = opts.lakes
  ADDgrid    = opts.grid
  ADDcities  = opts.cities
  ADDpoints  = opts.points
  ADDstation = opts.station
  ADDlegend  = opts.legend

# GEOcache allows for a resample cache of GEO satellites (speedy massproduction)
# These caches are stored in subdirectories with unique names .../nn_lut-*.zarr
GEOcache = False

# OVRCache speeds up static overlays. These are stored in your .../SPSdata/cache
# With caching you will sometimes have to delete *.png OVRcache files manually !
OVRcache = False

# If you are testing interactively while PyTROLL/SatPy image generation croned
# This allows for one interactively started script that will use tmpdirs/xtest
testrun = False

if opts.for_movie:
  (area,sarea)=resize_image(area)
  subdir = 'frames'
elif area[-4:]=='_rss':
  sarea=area
  subdir = 'frames'
else:
  sarea=area
  subdir = 'images'

create_dir(sat,subdir)

#Only if filename is given: test if file exists, don't overwrite
if opts.ofile!='':
  pfn=test_file_exist(sat,opts.dst,subdir,opts.ofile)
  if pfn != '':
    print(pfn+' exists, nothing done.')
    quit()

# ******** TOUCH THE CODE BELOW ONLY IF YOU KNOW WHAT YOU DO *********
# ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
reader='fci_l1c_nc'
kwargs = {} #'format_native':format_native}
height = geo_images(Yea, Mon, Day, Hou, Min, sat, segdir, decomp, isbulk, reader, composites,
                    sarea, area_cities, ADDcoasts, ADDborders, ADDrivers, ADDlakes, ADDgrid, ADDcities,
                    ADDpoints, ADDstation, GEOcache, OVRcache, testrun,**kwargs)  # basedir=basedir, subdir=subdir


# *******************************************************************
# POST PROCESSING LEGEND: WORKS WITH ALL SCRIPTS AND PROJECTION AREAS
# *******************************************************************

# Below is for legend only
sensor = 'fci'
# EUMETCast Europe service
service = 'HVS-2'
# EUMETSAT channel naming
channel = chan
# Logos in logos directory
logo1 = 'eumetsat_200x199.png'
logo2 = 'PyTROLL_400x400.jpg'

for composite in composites:

    magick = get_magick(Yea, Mon, Day, Hou, Min, height, logo1, logo2, service, channel,
                        receiver, sat, sensor, composite, area, testrun, ADDlegend,
                        subdir=subdir) # basedir=basedir, subdir=subdir

    magick,pfn=recreate_cmd(magick,opts.dst,opts.ofile,curdir)
    # **ImageMagick**
    os.system(magick)
    print('Generated '+pfn)
    if opts.do_view:
      satpy_viewer(pfn)

# If you get an image in the satellites tmp directory but no final image with
# legend at left then you have a problem with ImageMagick. THAT'S ALL FOLKS?!
