/*******************************************************************
 * RCSId: $Id: setup_rotors.ino,v 1.2 2025/06/21 14:24:11 ralblas Exp $
 *
 * Project: rotordrive
 * Author: R. Alblas
 *
 * content:
 *   init rotors
 *
 * functions:
 *   void setup_ax(ROTOR *)
 *   void setup_ey(ROTOR *)
 *
 * History: 
 *   
 * $Log: setup_rotors.ino,v $
 * Revision 1.2  2025/06/21 14:24:11  ralblas
 * _
 *
 * Revision 1.1  2025/05/06 17:19:30  ralblas
 * Initial revision
 *
 *
 *
 *******************************************************************/
/*******************************************************************
 * Copyright (C) 2020 R. Alblas. 
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software. If not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA.
 ********************************************************************/

#include "rotorctrl.h"
extern ROTORPREFS rotprefs;

void setup_prefs()
{
//  rotprefs.use_sgp4=USE_SGP4;
 #if USE_WIFI
  rotprefs.my_ssid1=MY_SSID1;
  rotprefs.my_pswd1=MY_PSWD1;
  rotprefs.my_hnam1=MY_HNAM1;

  rotprefs.my_ssid2=MY_SSID2;
  rotprefs.my_pswd2=MY_PSWD2;
 #endif

  rotprefs.ax_minspeed=AX_MINSPEED;
  rotprefs.ax_maxspeed=AX_MAXSPEED;
  rotprefs.ax_poffset=AX_POffset;
  rotprefs.ax_refpos=AX_REFPOS;
  rotprefs.ax_steps_degr=AX_STEPS_DEGR;
  rotprefs.ax_ldegr_maxspd=AX_L_DEGR_MAXSPD;
  rotprefs.ax_hdegr_minspd=AX_H_DEGR_MINSPD;
  rotprefs.ax_d_degr_stop=AX_D_DEGR_STOP;

  rotprefs.ey_minspeed=EY_MINSPEED;
  rotprefs.ey_maxspeed=EY_MAXSPEED;
  rotprefs.ey_poffset=EY_POffset;
  rotprefs.ey_refpos=EY_REFPOS;
  rotprefs.ey_steps_degr=EY_STEPS_DEGR;
  rotprefs.ey_ldegr_maxspd=EY_L_DEGR_MAXSPD;
  rotprefs.ey_hdegr_minspd=EY_H_DEGR_MINSPD;
  rotprefs.ey_d_degr_stop=EY_D_DEGR_STOP;

  rotprefs.spd_cal1=SPD_CAL1;
  rotprefs.spd_cal2=SPD_CAL2;

  rotprefs.bounce_period=BOUNCE_PERIOD;
  rotprefs.beam_width=BEAM_WIDTH;
  rotprefs.set_azim_min=SET_AZIM_MIN;
  rotprefs.set_azim_max=SET_AZIM_MAX;
  rotprefs.max_pwm=MAX_PWM;
}

void setup_prefs_ax(ROTOR *rot)
{
  if (!rot) return;

  rot->POffset        =rotprefs.ax_poffset;         // pulses from end switch to reference point
  rot->refpos         =rotprefs.ax_refpos;          // reference point in degrees
  #if ((MOTORTYPE == MOT_DC_PWM) || (MOTORTYPE == MOT_DC_FIX))
    rot->ldegr_maxspd=rotprefs.ax_ldegr_maxspd; // lowest error degree where speed is max. in %
    rot->hdegr_minspd=rotprefs.ax_hdegr_minspd; // highest error degree where speed reaches min. in %
    rot->d_degr_stop=rotprefs.ax_d_degr_stop;       // 
  #endif
  rot->steps_degr = rotprefs.ax_steps_degr;

  rot->degr=AX_STORM;
  rot->rotated = from_degr(rot);          // if power-off at storm pos. then no cal. needed

  #if ((MOTORTYPE == MOT_DC_PWM) || (MOTORTYPE == MOT_DC_FIX))
    rot->minspeed = rotprefs.ax_minspeed;
    rot->maxspeed = rotprefs.ax_maxspeed;
  #endif
  #if MOTORTYPE == MOT_STEPPER
    rot->stepper = &stepperAX;
    CMDP(rot, setMaxSpeed(AX_MotorSpeed));     // Set the X rotor-motor maximum speed
    CMDP(rot, setAcceleration(AX_MotorAccel)); // Set the X rotor-motor acceleration speed
  #endif
}

// setup rotor AX
void setup_ax(ROTOR *rot)
{
  if (!rot) return;
  setup_prefs_ax(rot);

  strcpy(rot->name, AX_NAME);
  rot->id = AX_ID;
  rot->round = 0;

  AX_set_pins(rot);
}

void setup_prefs_ey(ROTOR *rot)
{
  if (!rot) return;

  rot->POffset        =rotprefs.ey_poffset;          // pulses from end switch to reference point
  rot->refpos         =rotprefs.ey_refpos;           // reference point in degrees
  #if ((MOTORTYPE == MOT_DC_PWM) || (MOTORTYPE == MOT_DC_FIX))
    rot->ldegr_maxspd=rotprefs.ey_ldegr_maxspd; // lowest error degree where speed is max. in %
    rot->hdegr_minspd=rotprefs.ey_hdegr_minspd; // highest error degree where speed reaches min. in %
    rot->d_degr_stop=rotprefs.ey_d_degr_stop;       // 
  #endif

  rot->steps_degr = rotprefs.ey_steps_degr;

  rot->degr=EY_STORM;
  rot->rotated = from_degr(rot);          // if power-off at storm pos. then no cal. needed

  #if ((MOTORTYPE == MOT_DC_PWM) || (MOTORTYPE == MOT_DC_FIX))
    rot->minspeed = rotprefs.ey_minspeed;
    rot->maxspeed = rotprefs.ey_maxspeed;
  #endif
  #if MOTORTYPE == MOT_STEPPER
    rot->stepper = &stepperEY;
    CMDP(rot, setMaxSpeed(EY_MotorSpeed));     // Set the X rotor-motor maximum speed
    CMDP(rot, setAcceleration(EY_MotorAccel)); // Set the Y rotor-motor acceleration speed
  #endif
}

// setup rotor EY
void setup_ey(ROTOR *rot)
{
  if (!rot) return;

  setup_prefs_ey(rot);

  strcpy(rot->name, EY_NAME);
  rot->id = EY_ID;
  rot->round = 0;

  EY_set_pins(rot);

}
