#ifndef ROTORTYPES_HDR
#define ROTORTYPES_HDR

#include <Arduino.h>

// processor types
#define PROC_UNK 0
#define PROC_AVR 1
#define PROC_ESP 2


// display types: #define USE_DISPLAY
#define DISPL_NOT 0
#define DISPL_LCD 1
#define DISPL_OLED 2

// motor types
#define MOT_DC_FIX 1
#define MOT_DC_PWM 2
#define MOT_STEPPER 3

// rotor types
#define ROTORTYPE_XY 1
#define ROTORTYPE_AE 2

// id's for rotors
#define AX_ID 2                  // id of rotor 2
#define EY_ID 1                  // id of rotor 1

// only for SGP4 in controller: disc config.
#define X_AT_DISC 0
#define Y_AT_DISC 1

typedef bool boolean;

// Preferences
typedef struct rotorprefs
{
  boolean use_sgp4;
  boolean use_wifi;
  String my_ssid1;
  String my_pswd1;
  String my_hnam1;    // hostname

  String my_ssid2;
  String my_pswd2;

  int ax_minspeed;
  int ax_maxspeed;
  int ax_poffset;
  int ax_refpos;
  long ax_steps_degr;
  int ax_ldegr_maxspd;
  int ax_hdegr_minspd;
  float ax_d_degr_stop;

  int ey_minspeed;
  int ey_maxspeed;
  int ey_poffset;
  int ey_refpos;
  long ey_steps_degr;
  int ey_ldegr_maxspd;
  int ey_hdegr_minspd;
  float ey_d_degr_stop;

  int spd_cal1;
  int spd_cal2;

  int bounce_period;
  int beam_width;
  int set_azim_min;
  int set_azim_max;
  int max_pwm;
} ROTORPREFS;

// voor preferences nog te bekijken:
// common specs, to be done
//  boolean CAL_ZENIT;     // calibrate on zenit switch
//  boolean  USE_EASTWEST; // use info east or west pass
//  float D_DEGR_STOP;     // stop below this degree-error 
//  int  ServerPort;

// variables for rotor command
typedef struct goto_val
{
  float ax;                      // goto value azimut or Y
  float ey;                      // goto value elevation or X
  float x,y;
  float a,e;
  float lon,lat;
  float height;
  boolean east_pass;             // true if sat. passes east
  boolean eastwest_pass_info;    // true if east_pass is valid
} GOTO_VAL;

// Calibration steps
typedef enum
{
  cal_notdone=0,
  cal_prep_from_endpos,
  cal_from_endpos,
  cal_prep_to_endpos,
  cal_to_endpos,
  cal_prep_to_calpos,
  cal_to_calpos,

  cal_prep_to_zenit,
  goto_zenit,
  goto_zenit_reverse,
  cal_to_zenit,

  cal_ready,            // endpoint
  cal_err               // endpoin
} CALPROGRESS;

// Items for eacht rotor
typedef struct rotor
{
  char name[10];
  int id;
  long rotated;          // rotation done in some integer form (pulses, steps...)
  long pre_rotated;      // previous rotated (for run-check)
  long cnt        ;      // counter for run-check
  float req_degr;        // requested position rotor in degrees
  float degr;            // position rotor in degrees
  float p_degr;          // previous position rotor in degrees
  float err_degr;        // error
  long steps_degr;       // # steps (pulses) for 360 degrees rotation
  int speed;             // current speed
  int minspeed;          // minimum speed
  int maxspeed;          // maximum speed
  int ldegr_maxspd;      // threshold lowest degree diff. with max. speed
  int hdegr_minspd;      // threshold highest degree diff. with min. speed
  float d_degr_stop;     // allowed error degrees

  int motorspeed;        // max. motorspeed for stepper motor
  float d2v_slope;       // slope speed/degr
  int round;             // full 360 degrees
  boolean dir;           // direction
  boolean calibrated;    // calibration done and successfull
  boolean calibrating;   // calibration in operation
  boolean flipped;       // flipped direction
  CALPROGRESS cal_progress;
  int pwm;               // pwm: 0 (=stop)...100 (=max. speed) (percentage)
  boolean at_end1;       // end-stop activated
  boolean at_end2;       // end-stop activated
  boolean zenpin_inv;    // zenit: >90 or -90: inverted
  boolean zen_side;      // current zenit side
  int pin_pwm;           // pin nr. for PWM=speed
  int pin_dir;           // pin nr. for rotation direction
  int pin_din;           // pin nr. for inverted rotation direction
  int pin_zen;           // pin nr. for zenith detection
  int pin_lsp;           // pin nr. for low speed indication (if no PWM used)
  int pin_end1;          // pin nr. for end indication
  int pin_end2;          // pin nr. for end indication
  void *stepper;         // stepper class, for stepping motor
  boolean x_west_is_0;
  boolean y_south_is_0;
  
  unsigned long timeout; // for timeout detection 
  unsigned long timewait; // for timeout detection 

  // From Preferences (see also minspeed, maxspeed, steps_degr)
  int POffset;           // pulses from end switch to reference point
  float refpos;          // reference point in degrees
//  int l_degr_maxspeed;   // lowest error degree where speed is max. in %
//  int h_degr_minspeed;   // highest error degree where speed reaches min. in %
} ROTOR;

// commands
typedef enum current_command
{
  none=0,
  contrun_ax,contrun_ey,
  config,status,
  send_id,
  send_version,
  send_satpos,
  send_rotdata,
  send_kep,
  send_refpos,
  send_time,
  send_wifiinfo,
  do_calibrate,
  do_gotostorm,
  do_send_prefs,
  monitor,
  pwm_freq,
  do_gotoval,
  get_refpos,
  get_time,
  do_setup,
  restart
} CURRENT_COMMAND;

typedef enum comtype
{
  ct_none=0,
  ct_serial=1,
  ct_wifi=2,
  ct_both=3
} COMTYPE;

typedef struct commands
{
  CURRENT_COMMAND cmd;
  boolean contrunning;
  int a_spd,b_spd;
  int pwm_freq;
  GOTO_VAL gotoval;
  boolean set_refpos;
  float ref_lat,ref_lon;
  boolean pri_cmd;
  boolean got_new_pos;
  char time[20];

  boolean send_kep;
  boolean get_pos;
  boolean get_ctrldata;
  boolean run_calc;
} COMMANDS;

#endif

