/*******************************************************************
 * RCSId: $Id: rotorctrl.h,v 1.5 2025/08/04 15:16:14 ralblas Exp $
 *
 * Project: rotordrive
 * Author: R. Alblas
 *
 * content: header:
 *   def. of:
 *     structs etc.
 *
 * History: 
 * $Log: rotorctrl.h,v $
 * Revision 1.5  2025/08/04 15:16:14  ralblas
 * _
 *
 * Revision 1.4  2025/08/03 11:14:23  ralblas
 * _
 *
 * Revision 1.3  2025/08/02 10:05:58  ralblas
 * _
 *
 * Revision 1.2  2025/06/18 12:53:10  ralblas
 * _
 *
 * Revision 1.2  2023/09/03 18:39:05  ralblas
 * _
 *
 * Revision 1.1  2023/07/17 19:25:28  ralblas
 * Initial revision
 *
 *
 *******************************************************************/
/*******************************************************************
 * Copyright (C) 2020 R. Alblas. 
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software. If not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA.
 ********************************************************************/


#ifndef ROTORCTRL_HDR
#define ROTORCTRL_HDR

#include "rotorctrl_types.h"
#include "rotor_spec.h"

/*******************************************************
 * Define some extra features
 *******************************************************/
// monitor via serial UART interface
// !! Not capturing TX shouldn't be a problem, taken care of, 
//    but sometimes that doesn't work and everything slows down! 
#ifndef USE_MON_UART
#define USE_MON_UART true
#endif

/*******************************************************
 * Def. of functions and structs. For all configurations.
 *******************************************************/
#ifndef MIN
#define MIN(a,b) ((a)<(b)? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a)>(b)? (a) : (b))
#endif

#ifndef SIGN
#define SIGN(a) ((a)<0? -1 : (a)>0? 1 : 0)
#endif


// not defined in spec: set to default
#ifndef PROCESSOR
#define PROCESSOR PROC_ESP
#endif

// not defined in spec: set to default
#ifndef USE_DISPLAY
#define USE_DISPLAY DISPL_NOT
#endif

// not defined in spec: set to default
#ifndef USE_SGP4
  #define USE_SGP4 false
#endif

#if PROCESSOR==PROC_ESP
  #define LED_BUILTIN 2
  // translate pwm-pin to channel connected to that pin
  #define pin2chan(a) (a==PIN_ROTPWM_AX? 0 : 1)
  #define pwmWrite(a,b) ledcWrite(pin2chan(a),b) 
  #define ISR_FUNC void IRAM_ATTR
#else
  #define ISR_FUNC void 
#endif

#if ((MOTORTYPE == MOT_DC_PWM) || (MOTORTYPE == MOT_DC_FIX)) // DC motor
  #if PROCESSOR==PROC_AVR
    #include <PWM.h>
  #endif
#endif

#if USE_SGP4
  #include "rotorctrl_sgp4.h"
  #include "keplerfuncs.h"
#endif

#endif
