#ifdef WEG
unsigned long millis();
#include "rotorctrl.h"
extern COMMANDS command;

#define pwmWrite(a,b) ::ledcWrite(a,b)
class rotor_dc
{
  ROTOR rotor;
  private:
    // Set DC-motor speed; 'speed'=abs. value!
    static void set_speed(ROTOR *rot,int speed)
    {
      if (!rot) return;
      if (speed>100) speed=100;
      {
        rot->pwm=(MAX_PWM*speed)/100;
        if (rot->pin_pwm>=0) pwmWrite(rot->pin_pwm,rot->pwm);
      }

    }
    static void set_dir(ROTOR *rot,boolean dir)
    {
      boolean din;
      if (!rot) return;
      if (dir!=rot->dir)
      {
        set_speed(rot,0);
        delay(10);
      }
      rot->dir=dir;

      digitalWrite(rot->pin_dir, rot->dir);
      if (rot->pin_din>=0)
      {
        digitalWrite(rot->pin_din, (rot->dir? 0 : 1));
      }
    }

    static boolean is_moving(ROTOR *rot)
    {
      boolean running=true;
      if (!rot) return false;
      if (rot->rotated!=rot->pre_rotated)
      {
        rot->timeout=millis();
      }
      else if (millis()-rot->timeout > PLS_TIMEOUT)
      {
        running=false;
      }
      rot->pre_rotated=rot->rotated;
      return running;
    }

    // calc. degrees from step for 'rot'
    static float step2degr(ROTOR *rot,long step)
    {
      float degr;
      if (!rot) return 0.;
      degr=(float)step*360./(float)rot->steps_degr;
      return degr;
    }

    // position rotor in degrees
    float to_degr(ROTOR *rot)
    {
      if (!rot) return 0.;
      return step2degr(rot,rot->rotated);
    }

    long from_degr(ROTOR *rot)
    {
      if (!rot) return 0;
      return degr2step(rot,rot->degr);
    }

    // calc. steps from degrees for 'rot'
    static long degr2step(ROTOR *rot,float degr)
    {
      long step;
      if (!rot) return 0.;

      step=(long)((degr*rot->steps_degr)/360);
      #if SWAP_DIR
      step*=-1;
      #endif
      return step;
    }

  public:
  // Set speed of motor directly
    int run_motor_hard(ROTOR *rot,int speed);
    int run_motor_soft(ROTOR *rot,int speed);
    int calrot_estop(ROTOR *rot);
  
};

// Set speed of motor directly
int rotor_dc::run_motor_hard(ROTOR *rot,int speed)
{
  if (!rot) return 0;

  // set speed and run (without accelleration)

  if (speed)
    set_dir(rot,speed > 0? 1 : 0);
  set_speed(rot,abs(speed));
  rot->speed=speed;
  return speed;
}

// soft speed control (accel.)
// return: stepper: actual speed
//         DC: acc. speed from input speed
//         stepper: only acc. up, change maxspeed gives no nice accel!
int rotor_dc::run_motor_soft(ROTOR *rot,int speed)
{
  if (!rot) return 0;

  // set speed and run (accelleration)

  speed=accellerate(rot,speed,1,1);
  if (speed)
    set_dir(rot,speed > 0? 1 : 0);
  set_speed(rot,abs(speed));
  rot->speed=speed;
  return speed;
}

int rotor_dc::calrot_estop(ROTOR *rot)
{
  boolean busy;
  int speed[2];
  float pos;
  if (!rot) return 0;
  speed[0]=SPD_CAL1;
  speed[1]=SPD_CAL2;

  #if SWAP_DIR == false
    speed[0]*=-1;
    speed[1]*=-1;
  #endif


  switch(rot->cal_progress)
  {
    case pcal_notdone: default:
      run_motor_hard(rot,0);
      command.gotoval.east_pass=true;         // keep rotors after calibration at 0, don't flip

      rot->cal_progress=pcal_prep_from_endpos;
    break;

    case pcal_prep_from_endpos:                // prepare to run from switch:
    {
      pos=DEGR_FORWARD;                        //   go DEGR_FORWARD degrees from end-switch
      reset_for_cal(rot);
      pos=pos+to_degr(rot);                    //   force to go forward DEGR_FORWARD degrees
      rot->timeout=millis();                   //   start time: for timeout

      rot->cal_progress=pcal_from_endpos;
    }
    break;

    case pcal_from_endpos:                     // run from switch;
    {
      busy=rotor_goto(rot,pos);               //   run until DEGR_FORWARD forward
      if ((!busy) || (!(is_moving(rot))))
      {                                       //   ready, or maybe rotor was at other end, so didn't move? 
        run_motor_hard(rot,0);                //   stop

        rot->cal_progress=pcal_prep_to_endpos;
      }
    }
    break;

    case pcal_prep_to_endpos:                  // prepare to run to switch:
      reset_to_pos(rot,-1*rot->POffset);      //   set puls counter to # pulses to calibration position
      rot->timeout=millis();                    //   for timeout

      rot->cal_progress=pcal_to_endpos; //   motor stopped, at end switch
    break;

    case pcal_to_endpos:                       // run to end switch
      run_motor_soft(rot,speed[0]);           //   run with speed 'speed'
      if (!(is_moving(rot)));                 //   detect moving
      {
        rot->cal_progress=pcal_prep_to_calpos; //   motor stopped, at end switch
      }
    break;

    case pcal_prep_to_calpos:                  // prepare go to calibration point
      reset_to_pos(rot,-1*rot->POffset);       //   set suchh that rotor stops 'POffset' pulses after end-swutch
      rot->timeout=millis();                    //   for timeout

      rot->cal_progress=pcal_to_calpos;        //
    break;

    case pcal_to_calpos:                      // go to calibration point
      if (!(is_moving(rot)))      //   timeout, stop.
        rot->cal_progress=pcal_err;

//      if (!rotor_goto(rot,pos))
//        rot->cal_progress=pcal_ready;


    case pcal_err:
      run_motor_hard(rot,0);
      rot->calibrated=false;
      rot->cal_ready=true;
      rot->cal_status=cal_err;
      return 1;                               // end-of-calibration (though errored)
    break;

    case pcal_ready:
      run_motor_hard(rot,0);
      rot->degr=rot->refpos;                  // Set degrees to reference position
      rot->rotated=from_degr(rot);            // Set pulse count to reference position
      rot->calibrated=true;
      rot->cal_ready=true;
      return 1;                               // end-of-calibration, OK
    break;
  }
  return 0;

}

#endif
