/*******************************************************************
 * RCSId: $Id: preferences.ino,v 1.2 2025/08/06 08:51:07 ralblas Exp $
 *
 * Project: rotordrive
 * Author: R. Alblas
 *
 * content: 
 *   Handling preferences
 *
 * public functions:
 *
 * History: 
 * $Log$
 *
 *******************************************************************/
/*******************************************************************
 * Copyright (C) 2025 R. Alblas. 
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software. If not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA.
 ********************************************************************/
 /*
  * Usage: via Telnet:
  * download_prefs		show all prefs
  * PREF: AX_MINSPEED=60	change AX_MINSPEED, will be used, not saved yet
  * SAVE: AX_MINSPEED		save AX_MINSPEED in preferences
  */
#include "rotorctrl.h"
#if USE_PREFS
#include <Preferences.h>

Preferences preferences;
extern ROTORPREFS rotprefs;
ROTORPREFS rotprefs_sav;

// load prefrences, define defaults for items not saved yet
void load_prefs()
{
  preferences.begin("rotor", false);

 #if USE_WIFI
  rotprefs_sav.use_wifi=preferences.getBool("use_wifi"               , USE_WIFI);
  rotprefs_sav.use_sgp4=preferences.getBool("use_sgp4"               , USE_SGP4);

  rotprefs_sav.my_ssid1=preferences.getString("my_ssid1"             , MY_SSID1);
  rotprefs_sav.my_pswd1=preferences.getString("my_pswd1"             , MY_PSWD1);
  rotprefs_sav.my_hnam1=preferences.getString("my_hnam1"             , MY_HNAM1);

  rotprefs_sav.my_ssid2=preferences.getString("my_ssid2"             , MY_SSID2);
  rotprefs_sav.my_pswd2=preferences.getString("my_pswd2"             , MY_PSWD2);
 #endif

  rotprefs_sav.ax_minspeed=preferences.getInt("ax_minspeed"          , AX_MINSPEED);
  rotprefs_sav.ax_maxspeed=preferences.getInt("ax_maxspeed"          , AX_MAXSPEED);
  rotprefs_sav.ax_poffset=preferences.getInt("ax_poffset"            , AX_POffset);
  rotprefs_sav.ax_refpos=preferences.getInt("ax_refpos"              , AX_REFPOS);
  rotprefs_sav.ax_steps_degr=preferences.getLong("ax_steps_degr"     , AX_STEPS_DEGR);
  rotprefs_sav.ax_ldegr_maxspd=preferences.getInt("ax_ldegr_maxspd"  , AX_L_DEGR_MAXSPD);
  rotprefs_sav.ax_hdegr_minspd=preferences.getInt("ax_hdegr_minspd"  , AX_H_DEGR_MINSPD);
  rotprefs_sav.ax_d_degr_stop=preferences.getFloat("ax_d_degr_stop"  , AX_D_DEGR_STOP);

  rotprefs_sav.ey_minspeed=preferences.getInt("ey_minspeed"          , EY_MINSPEED);
  rotprefs_sav.ey_maxspeed=preferences.getInt("ey_maxspeed"          , EY_MAXSPEED);
  rotprefs_sav.ey_poffset=preferences.getInt("ey_poffset"            , EY_POffset);
  rotprefs_sav.ey_refpos=preferences.getInt("ey_refpos"              , EY_REFPOS);
  rotprefs_sav.ey_steps_degr=preferences.getInt("ey_steps_degr"      , EY_STEPS_DEGR);
  rotprefs_sav.ey_ldegr_maxspd=preferences.getInt("ey_ldegr_maxspd"  , EY_L_DEGR_MAXSPD);
  rotprefs_sav.ey_hdegr_minspd=preferences.getInt("ey_hdegr_minspd"  , EY_H_DEGR_MINSPD);
  rotprefs_sav.ey_d_degr_stop=preferences.getFloat("ey_d_degr_stop"  , EY_D_DEGR_STOP);

  rotprefs_sav.set_azim_min=preferences.getInt("set_azim_min"        , SET_AZIM_MIN);  
  rotprefs_sav.set_azim_max=preferences.getInt("set_azim_max"        , SET_AZIM_MAX);  


  rotprefs_sav.spd_cal1=preferences.getInt("spd_cal1"                , SPD_CAL1);      
  rotprefs_sav.spd_cal2=preferences.getInt("spd_cal2"                , SPD_CAL2);      

  rotprefs_sav.bounce_period=preferences.getInt("bounce_period"      , BOUNCE_PERIOD); 
  rotprefs_sav.beam_width=preferences.getInt("beam_width"            , BEAM_WIDTH);    
  rotprefs_sav.max_pwm=preferences.getInt("max_pwm"                  , MAX_PWM);       

  rotprefs=rotprefs_sav;  // copy to prefs to use
  //preferences.end();
}

#define do_save(cmd,wat) ((!cmd) || (!strcmp(cmd,"ALL")) || (!strcmp(cmd,wat)))
// save one or all items in preferences (except ssid/pswd if in use)
void save_prefs(char *cmd,int ssid_used,bool force)
{
  if (do_save(cmd,"USE_WIFI"))           preferences.putBool("use_wifi", rotprefs.use_wifi);
  if (do_save(cmd,"USE_SGP4"))           preferences.putBool("use_sgp4", rotprefs.use_sgp4);

  if ((ssid_used!=1) || (force))
  {
    if (do_save(cmd,"MY_SSID1"))         preferences.putString("my_ssid1", rotprefs.my_ssid1);
    if (do_save(cmd,"MY_PSWD1"))         preferences.putString("my_pswd1", rotprefs.my_pswd1);
    if (do_save(cmd,"MY_HNAM1"))         preferences.putString("my_hnam1", rotprefs.my_hnam1);
  }

  if ((ssid_used!=2) || (force))
  {
    if (do_save(cmd,"MY_SSID2"))         preferences.putString("my_ssid2", rotprefs.my_ssid2);
    if (do_save(cmd,"MY_SSID2"))         preferences.putString("my_pswd2", rotprefs.my_pswd2);
  }

  if (do_save(cmd,"AX_MINSPEED"))        preferences.putInt("ax_minspeed", rotprefs.ax_minspeed);

  if (do_save(cmd,"AX_MAXSPEED"))        preferences.putInt("ax_maxspeed", rotprefs.ax_maxspeed);
  if (do_save(cmd,"AX_POFFSET"))         preferences.putInt("ax_poffset", rotprefs.ax_poffset);
  if (do_save(cmd,"AX_REFPOS"))          preferences.putInt("ax_refpos", rotprefs.ax_refpos);
  if (do_save(cmd,"AX_STEPS_DEGR"))      preferences.putLong("ax_steps_degr", rotprefs.ax_steps_degr);
  if (do_save(cmd,"AX_L_DEGR_MAXSPD"))   preferences.putInt("ax_ldegr_maxspd", rotprefs.ax_ldegr_maxspd);
  if (do_save(cmd,"AX_H_DEGR_MINSPD"))   preferences.putInt("ax_hdegr_minspd", rotprefs.ax_hdegr_minspd);
  if (do_save(cmd,"AX_D_DEGR_STOP"))     preferences.putFloat("ax_d_degr_stop", rotprefs.ax_d_degr_stop);

  if (do_save(cmd,"EY_MINSPEED"))        preferences.putInt("ey_minspeed", rotprefs.ey_minspeed);
  if (do_save(cmd,"EY_MAXSPEED"))        preferences.putInt("ey_maxspeed", rotprefs.ey_maxspeed);
  if (do_save(cmd,"EY_POFFSET"))         preferences.putInt("ey_poffset", rotprefs.ey_poffset);
  if (do_save(cmd,"EY_REFPOS"))          preferences.putInt("ey_refpos", rotprefs.ey_refpos);
  if (do_save(cmd,"EY_STEPS_DEGR"))      preferences.putLong("ey_steps_degr", rotprefs.ey_steps_degr);
  if (do_save(cmd,"EY_L_DEGR_MAXSPD"))   preferences.putInt("ey_ldegr_maxspd", rotprefs.ey_ldegr_maxspd);

  if (do_save(cmd,"EY_H_DEGR_MINSPD"))   preferences.putInt("ey_hdegr_minspd", rotprefs.ey_hdegr_minspd);
  if (do_save(cmd,"EY_D_DEGR_STOP"))     preferences.putFloat("ey_d_degr_stop", rotprefs.ey_d_degr_stop);

  if (do_save(cmd,"SET_AZIM_MIN"))       preferences.putInt("set_azim_min", rotprefs.set_azim_min);
  if (do_save(cmd,"SET_AZIM_MAX"))       preferences.putInt("set_azim_max", rotprefs.set_azim_max);

  if (do_save(cmd,"SPD_CAL1"))           preferences.putInt("spd_cal1", rotprefs.spd_cal1);
  if (do_save(cmd,"SPD_CAL2"))           preferences.putInt("spd_cal2", rotprefs.spd_cal2);

  if (do_save(cmd,"BOUNCE_PERIOD"))      preferences.putInt("bounce_period", rotprefs.bounce_period);
  if (do_save(cmd,"BEAM_WIDTH"))         preferences.putInt("beam_width", rotprefs.beam_width);
  if (do_save(cmd,"MAX_PWM"))            preferences.putInt("max_pwm", rotprefs.max_pwm);

  //rotprefs_sav=rotprefs; // can't restore anymore...
}

// get from pc, set preference-items for use (not saved yet)
void get_prefs(char *cmd,int ssid_used,bool force)
{
  char *p;

  if ((ssid_used!=1) || (force))
  {
    if      ((p=get_val(cmd,"MY_SSID1=")))       rotprefs.my_ssid1=p;
    if      ((p=get_val(cmd,"MY_PSWD1=")))       rotprefs.my_pswd1=p;
    if      ((p=get_val(cmd,"MY_HNAM1=")))       rotprefs.my_hnam1=p;
  }
  if ((ssid_used!=2) || (force))
  {
    if      ((p=get_val(cmd,"MY_SSID2=")))       rotprefs.my_ssid2=p;
    if      ((p=get_val(cmd,"MY_PSWD2=")))       rotprefs.my_pswd2=p;
  }

  if      ((p=get_val(cmd,"USE_WIFI=")))         rotprefs.use_wifi=atoi(p);
  else if ((p=get_val(cmd,"USE_SGP4=")))         rotprefs.use_sgp4=atoi(p);
  else if ((p=get_val(cmd,"AX_MINSPEED=")))      rotprefs.ax_minspeed=atoi(p);
  else if ((p=get_val(cmd,"AX_MAXSPEED=")))      rotprefs.ax_maxspeed=atoi(p);
  else if ((p=get_val(cmd,"AX_POFFSET=")))       rotprefs.ax_poffset=atoi(p);
  else if ((p=get_val(cmd,"AX_REFPOS=")))        rotprefs.ax_refpos=atoi(p);
  else if ((p=get_val(cmd,"AX_STEPS_DEGR=")))    rotprefs.ax_steps_degr=atoi(p);
  else if ((p=get_val(cmd,"AX_L_DEGR_MAXSPD="))) rotprefs.ax_ldegr_maxspd=atoi(p);
  else if ((p=get_val(cmd,"AX_H_DEGR_MINSPD="))) rotprefs.ax_hdegr_minspd=atoi(p);
  else if ((p=get_val(cmd,"AX_D_DEGR_STOP=")))   rotprefs.ax_d_degr_stop=atof(p);

  else if ((p=get_val(cmd,"EY_MINSPEED=")))      rotprefs.ey_minspeed=atoi(p);
  else if ((p=get_val(cmd,"EY_MEYSPEED=")))      rotprefs.ey_maxspeed=atoi(p);
  else if ((p=get_val(cmd,"EY_POFFSET=")))       rotprefs.ey_poffset=atoi(p);
  else if ((p=get_val(cmd,"EY_REFPOS=")))        rotprefs.ey_refpos=atoi(p);
  else if ((p=get_val(cmd,"EY_STEPS_DEGR=")))    rotprefs.ey_steps_degr=atoi(p);
  else if ((p=get_val(cmd,"EY_L_DEGR_MAXSPD="))) rotprefs.ey_ldegr_maxspd=atoi(p);
  else if ((p=get_val(cmd,"EY_H_DEGR_MINSPD="))) rotprefs.ey_hdegr_minspd=atoi(p);
  else if ((p=get_val(cmd,"EY_D_DEGR_STOP=")))   rotprefs.ey_d_degr_stop=atof(p);

  else if ((p=get_val(cmd,"SET_AZIM_MIN=")))     rotprefs.set_azim_min=atoi(p);  
  else if ((p=get_val(cmd,"SET_AZIM_MAX=")))     rotprefs.set_azim_max=atoi(p);  


  else if ((p=get_val(cmd,"SPD_CAL1=")))         rotprefs.spd_cal1=atoi(p);      
  else if ((p=get_val(cmd,"SPD_CAL2=")))         rotprefs.spd_cal2=atoi(p);      

  else if ((p=get_val(cmd,"BOUNCE_PERIOD=")))    rotprefs.bounce_period=atoi(p); 
  else if ((p=get_val(cmd,"BEAM_WIDTH=")))       rotprefs.beam_width=atoi(p);    

  else if ((p=get_val(cmd,"MAX_PWM=")))          rotprefs.max_pwm=atoi(p);       

  else if ((p=get_val(cmd,"restore_prefs")))     rotprefs=rotprefs_sav;          
}

// send preferences to pc
void send_prefs(COMTYPE ct,ROTORPREFS *rp)
{
  xprintf(ct,"PREF: USE_WIFI=%d\n",rp->use_wifi);
  xprintf(ct,"PREF: USE_SGP4=%d\n",rp->use_sgp4);
  xprintf(ct,"PREF: MY_SSID1=%s\n",rp->my_ssid1.c_str());
  xprintf(ct,"PREF: MY_PSWD1=%s\n",rp->my_pswd1.c_str());
  xprintf(ct,"PREF: MY_HNAM1=%s\n",rp->my_hnam1.c_str());
  xprintf(ct,"PREF: MY_SSID2=%s\n",rp->my_ssid2.c_str());
  xprintf(ct,"PREF: MY_PSWD2=%s\n",rp->my_pswd2.c_str());

  xprintf(ct,"PREF: AX_MINSPEED=%d\n",rp->ax_minspeed);
  xprintf(ct,"PREF: AX_MAXSPEED=%d\n",rp->ax_maxspeed);
  xprintf(ct,"PREF: AX_POFFSET=%d\n",rp->ax_poffset);
  xprintf(ct,"PREF: AX_REFPOS=%d\n",rp->ax_refpos);
  xprintf(ct,"PREF: AX_STEPS_DEGR=%d\n",rp->ax_steps_degr);
  xprintf(ct,"PREF: AX_L_DEGR_MAXSPD=%d\n",rp->ax_ldegr_maxspd);
  xprintf(ct,"PREF: AX_H_DEGR_MINSPD=%d\n",rp->ax_hdegr_minspd);
  xprintf(ct,"PREF: AX_D_DEGR_STOP=%.1f\n",rp->ax_d_degr_stop);

  xprintf(ct,"PREF: EY_MINSPEED=%d\n",rp->ey_minspeed);
  xprintf(ct,"PREF: EY_MAXSPEED=%d\n",rp->ey_maxspeed);
  xprintf(ct,"PREF: EY_POFFSET=%d\n",rp->ey_poffset);
  xprintf(ct,"PREF: EY_REFPOS=%d\n",rp->ey_refpos);
  xprintf(ct,"PREF: EY_STEPS_DEGR=%d\n",rp->ey_steps_degr);     
  xprintf(ct,"PREF: EY_L_DEGR_MAXSPD=%d\n",rp->ey_ldegr_maxspd);
  xprintf(ct,"PREF: EY_H_DEGR_MINSPD=%d\n",rp->ey_hdegr_minspd);
  xprintf(ct,"PREF: EY_D_DEGR_STOP=%.1f\n",rp->ey_d_degr_stop);

  xprintf(ct,"PREF: SET_AZIM_MIN=%d\n",rp->set_azim_min);
  xprintf(ct,"PREF: SET_AZIM_MAX=%d\n",rp->set_azim_max);


  xprintf(ct,"PREF: SPD_CAL1=%d\n",rp->spd_cal1);
  xprintf(ct,"PREF: SPD_CAL2=%d\n",rp->spd_cal2);

  xprintf(ct,"PREF: BOUNCE_PERIOD=%d\n",rp->bounce_period);
  xprintf(ct,"PREF: BEAM_WIDTH=%d\n",rp->beam_width);
  xprintf(ct,"PREF: MAX_PWM=%d\n",rp->max_pwm);
  xprintf(ct,"END!\n");
}
#endif
