// OLED: 128x64, ASCII 4 or 8 lines, 15? chars/line
#include "rotorctrl.h"
#if USE_DISPLAY == DISPL_OLED
#include "U8g2lib.h"
#include <stdarg.h>

U8G2_SH1106_128X64_NONAME_2_HW_I2C u8g2(U8G2_R0);

void setup_oled()
{
  u8g2.begin();
  u8g2.firstPage(); 
  u8g2.setFont(u8g2_font_t0_15b_mf);
  u8g2.setAutoPageClear(0);
}

#define FONTW 8
#define OFFSX 0
#define OFFSY 12
static void dspiprintf(int x, int y,char *s,...)
{
  char si[20];
  memset(si,' ',sizeof(si));
  va_list ap;
  va_start(ap,s);
  vsnprintf(si,16-x,s,ap);
  va_end(ap);

  x=x*FONTW+OFFSX;
  u8g2.setBufferCurrTileRow(0);
  u8g2.drawStr(x,OFFSY,si);
  u8g2.setBufferCurrTileRow(y*2);
  u8g2.sendBuffer();
}

void oprintf(int x, int y,char *s,...)
{
  char s1[20];
  char si[20];
  strncpy(s1,s,20);
  strncat(s1,"                ",16-strlen(s));
  memset(si,' ',sizeof(si));
  va_list ap;
  va_start(ap,s);
  vsnprintf(si,16,s1,ap);
  va_end(ap);
  dspiprintf(x, y,si);
}

void ax_oprint(int y,char *s)
{
  char si[16];
  strncpy(si,s,7); 
  strcat(si,"       ");
  si[7]=0;
  dspiprintf(0, y,si);
}

void ey_oprint(int y,char *s)
{
  char si[16];
  strncpy(si,s,7); 
  strcat(si,"       ");
  si[7]=0;
  dspiprintf(0+9, y,si);
}
#endif
