/*******************************************************************
 * RCSId: $Id: monitor.ino,v 1.2 2025/06/18 11:10:20 ralblas Exp $
 *
 * Project: rotordrive
 * Author: R. Alblas
 *
 * content: 
 *   monitor functions:
 *     void send_specs(ROTOR *AX_rot,ROTOR *EY_rot)
 *     void send_stat(ROTOR *AX_rot,ROTOR *EY_rot)
 *
 * History: 
 * $Log: monitor.ino,v $
 * Revision 1.2  2025/06/18 11:10:20  ralblas
 * _
 *
 * Revision 1.1  2025/04/11 19:27:47  ralblas
 * Initial revision
 *
 * Revision 1.2  2023/08/16 20:42:11  ralblas
 * _
 *
 * Revision 1.1  2023/07/17 18:57:33  ralblas
 * Initial revision
 *
 *
 *
 *******************************************************************/
/*******************************************************************
 * Copyright (C) 2020 R. Alblas. 
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software. If not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA.
 ********************************************************************/
// Send rotor specs
// delay between 2 write actions, to prevent buffer overflow
extern ROTORPREFS rotprefs;
#define SERDEL 10
void send_specs(ROTOR *AX_rot,ROTOR *EY_rot)
{
  char tmp[10];

  xprintf("SPEC: Release %s\n",RELEASE);                                 delay(SERDEL);
  xprintf("SPEC: AX_POffset     =%ld\n",(long)AX_rot->POffset);          delay(SERDEL);
  xprintf("SPEC: EY_POffset     =%ld\n",(long)EY_rot->POffset);          delay(SERDEL);

  xprintf("SPEC: AX_REFPOS      =%s\n",dtostrf(AX_rot->refpos,5,1,tmp)); delay(SERDEL);
  xprintf("SPEC: EY_REFPOS      =%s\n",dtostrf(EY_rot->refpos,5,1,tmp)); delay(SERDEL);

  xprintf("SPEC: AX_STEPS_DEGR  =%ld\n",AX_rot->steps_degr);             delay(SERDEL);
  xprintf("SPEC: EY_STEPS_DEGR  =%ld\n",EY_rot->steps_degr);             delay(SERDEL);

  xprintf("SPEC: CAL_ZENITH     =%d\n",(int)CAL_ZENITH);                 delay(SERDEL);

  #ifdef USE_EASTWEST
    xprintf("SPEC: USE_EASTWEST   =%ld\n",(long)USE_EASTWEST);           delay(SERDEL);
  #endif
  #ifdef FULLRANGE_AZIM
    xprintf("SPEC: FULLRANGE_AZIM =%ld\n",(long)FULLRANGE_AZIM);         delay(SERDEL);
  #endif

 #if MOTORTYPE == MOT_STEPPER
  xprintf("SPEC: AX_MotorSpeed   =%d\n",(int)AX_MotorSpeed);              delay(SERDEL);
  xprintf("SPEC: AX_MotorAccel   =%d\n",(int)AX_MotorAccel);              delay(SERDEL);
  xprintf("SPEC: EY_MotorSpeed   =%d\n",(int)EY_MotorSpeed);              delay(SERDEL);
  xprintf("SPEC: EY_MotorAccel   =%d\n",(int)EY_MotorAccel);              delay(SERDEL);
 #else
  xprintf("SPEC: AX_MINSPEED     =%d\n",AX_rot->minspeed);                delay(SERDEL);
  xprintf("SPEC: AX_MAXSPEED     =%d\n",AX_rot->maxspeed);                delay(SERDEL);
  xprintf("SPEC: AX_L_DEGR_MAXSPD=%d\n",AX_rot->ldegr_maxspd);            delay(SERDEL);
  xprintf("SPEC: AX_H_DEGR_MINSPD=%d\n",AX_rot->hdegr_minspd);            delay(SERDEL);
  xprintf("SPEC: AX_D_DEGR_STOP  =%s\n",dtostrf(AX_rot->d_degr_stop,5,1,tmp)); delay(SERDEL);

  xprintf("SPEC: EY_MINSPEED     =%d\n",EY_rot->minspeed);                delay(SERDEL);
  xprintf("SPEC: EY_MAXSPEED     =%d\n",EY_rot->maxspeed);                delay(SERDEL);
  xprintf("SPEC: EY_L_DEGR_MAXSPD=%d\n",EY_rot->ldegr_maxspd);            delay(SERDEL);
  xprintf("SPEC: EY_H_DEGR_MINSPD=%d\n",EY_rot->hdegr_minspd);            delay(SERDEL);
  xprintf("SPEC: EY_D_DEGR_STOP  =%s\n",dtostrf(EY_rot->d_degr_stop,5,1,tmp)); delay(SERDEL);
  xprintf("SPEC: PWMFreq         =%d\n",(int)PWMFreq);                    delay(SERDEL);
  xprintf("SPEC: MAX_PWM         =%d\n",rotprefs.max_pwm);                delay(SERDEL);
  xprintf("END!\n");                                                      delay(SERDEL);
 #endif
 #if USE_SGP4
 {
   #include <time.h>
   time_t t;
   struct tm tm;
   time(&t);
   tm=*gmtime(&t);
   xprintf("TIME: %d-%02d-%02d %02d:%02d:%02d\n",tm.tm_year+1900,tm.tm_mon,tm.tm_mday,tm.tm_hour,tm.tm_min,tm.tm_sec);
  }
  #endif
  xprintf("END!\n");
}

// Send status
void send_stat(COMTYPE ct,ROTOR *AX_rot,ROTOR *EY_rot)
{
  int stat_ax=-1,stat_ey=-1;
  int cnt_ax=0,cnt_ey=0;
  if (AX_rot) cnt_ax=AX_rot->rotated;
  if (EY_rot) cnt_ey=EY_rot->rotated;
  xprintf(ct,"STAT: cntax=%d cntey=%d\n",cnt_ax,cnt_ey);
}

char *cal_prgs_code2str(CALPROGRESS cp)
{
  switch(cp)
  {
    case cal_notdone     : return "not done";
    case cal_from_endpos : return "from endpos";
    case cal_to_endpos   : return "to endpos";
    case cal_to_calpos   : return "to calibration pos";
    case cal_ready       : return "ready";
    case cal_err         : return "error";
  }
  return NULL;
}

void send_posx(ROTOR *AX_rot,ROTOR *EY_rot)
{
  COMTYPE ct=ct_both;

  static int sec;
  static char m_ax[20],m_ey[20];
  static CALPROGRESS cp_ax,cp_ey;
  char *m[2];
  int cnt_ax=0,cnt_ey=0;
  float degr_ax,degr_ey;
  float req_degr_ax,req_degr_ey;
  float err_degr_ax,err_degr_ey;
  boolean changed=false;

  if  ((AX_rot) && (AX_rot->cal_progress != cp_ax)) { changed=true; cp_ax=AX_rot->cal_progress; }
  if  ((EY_rot) && (EY_rot->cal_progress != cp_ey)) { changed=true; cp_ey=EY_rot->cal_progress; }

  if ((millis()-sec > 1000) || (changed))
  {
    sec=millis();
    if (AX_rot)
    {
      cnt_ax=AX_rot->rotated;
      degr_ax=AX_rot->degr;
      req_degr_ax=AX_rot->req_degr;
      err_degr_ax=AX_rot->err_degr;
      m[0]=cal_prgs_code2str(AX_rot->cal_progress);
      if (m[0]) strncpy(m_ax,m[0],20);
    }
    if (EY_rot)
    {
      cnt_ey=EY_rot->rotated;
      degr_ey=EY_rot->degr;
      req_degr_ey=EY_rot->req_degr;
      err_degr_ey=EY_rot->err_degr;
      m[1]=cal_prgs_code2str(EY_rot->cal_progress);
      if (m[1]) strncpy(m_ey,m[1],20);
    }
    xprintf(ct,"RPOS: stat_ax=%s  ",m_ax);

    xprintf(ct,"RPOS: stat_ax=\"%s\"\nstat_ey=\"%s\"\n",m_ax,m_ey);
    xprintf(ct,"RPOS: cnt_ax=\"%d\"\ncnt_ey=\"%d\"\n",cnt_ax,cnt_ey);

    xprintf(ct,"RPOS: req_degr_ax=\"%f\"\nreq_degr_ey=\"%f\"\n",req_degr_ax,req_degr_ey);

    xprintf(ct,"RPOS: degr_ax=\"%f\"\ndegr_ey=\"%f\"\n",degr_ax,m_ey);

    xprintf(ct,"RPOS: err_degr_ax=\"%f\"\nerr_degr_ey=\"%f\"\n",err_degr_ax,err_degr_ey);
  }
}

#ifdef DISPLAY_FUNCS
// current ax/ey to display
void rec2displ(int ep,float ax,float ey)
{
  static int nr;
  char str1[10],str2[10];

  dtostrf(ax,6, 1, str1);
  dtostrf(ey,6, 1, str2);
  xdispprintf(0,0,"cmd: %d  %6s  %6s",ep,str1,str2);
  xdispprintf(0,1,"nr=%d",++nr);
}
#endif
