###################################################################
# Script for S7Mini FPGA board
# Usage:
#  program fpga:
#    vivado -mode tcl -notrace -source do_s7mini_satdecgen.tcl -tclargs p
#  program flash:
#    vivado -mode tcl -notrace -source do_s7mini_satdecgen.tcl -tclargs P
#
###################################################################
#base name
set pname "satdecgen"

#create filenames from pname 
set fpgafile $pname.bit
set flshfile $pname.bin
###################################################################
# Script for S7Mini FPGA board
# Usage:
#  synthesize:
#    vivado -mode tcl -notrace -source do_s7mini_satdecgen.tcl -tclargs s
#  program fpga:
#    vivado -mode tcl -notrace -source do_s7mini_satdecgen.tcl -tclargs p
#  program flash:
#    vivado -mode tcl -notrace -source do_s7mini_satdecgen.tcl -tclargs P
#
###################################################################
set doe_synth false
set doe_progfpga false
set doe_progflsh false

# handle arguments
if { $argc > 0 } {
  if { $argv == "h" } {
    puts "options: p | f"
    quit
  }
  if { $argv == "p" } {
    set doe_progfpga true
  }
  if { $argv == "f" } {
    set doe_progflsh true
  }
} else {
  #select what to run
  set doe_synth false
  set doe_progfpga false
  set doe_progflsh false
}

if { $doe_progfpga } {
  open_hw_manager
  connect_hw_server -allow_non_jtag
  open_hw_target
  set_property PROBES.FILE {} [get_hw_devices xc7s25_0]
  set_property FULL_PROBES.FILE {} [get_hw_devices xc7s25_0]
  set_property PROGRAM.FILE $fpgafile [get_hw_devices xc7s25_0]
  program_hw_devices [get_hw_devices xc7s25_0]

  puts ">>>>>>>>>> Loaded into fpga $fpgafile"
}


if { $doe_progflsh } {
  open_hw
  connect_hw_server
  current_hw_target [get_hw_targets *]
  open_hw_target
  create_hw_cfgmem -hw_device [lindex [get_hw_devices xc7s25_0] 0] [lindex [get_cfgmem_parts {is25lp064a-spi-x1_x2_x4}] 0]
  
  set_property PROGRAM.ADDRESS_RANGE  {use_file} [ get_property PROGRAM.HW_CFGMEM [lindex [get_hw_devices xc7s25_0] 0]]
  set_property PROGRAM.FILES [list $flshfile ] [ get_property PROGRAM.HW_CFGMEM [lindex [get_hw_devices xc7s25_0] 0]]
  set_property PROGRAM.PRM_FILE {} [ get_property PROGRAM.HW_CFGMEM [lindex [get_hw_devices xc7s25_0] 0]]
  set_property PROGRAM.UNUSED_PIN_TERMINATION {pull-none} [ get_property PROGRAM.HW_CFGMEM [lindex [get_hw_devices xc7s25_0] 0]]

  set_property PROGRAM.BLANK_CHECK  0 [ get_property PROGRAM.HW_CFGMEM [lindex [get_hw_devices xc7s25_0] 0]]
  set_property PROGRAM.ERASE  1 [ get_property PROGRAM.HW_CFGMEM [lindex [get_hw_devices xc7s25_0] 0]]
  set_property PROGRAM.CFG_PROGRAM  1 [ get_property PROGRAM.HW_CFGMEM [lindex [get_hw_devices xc7s25_0] 0]]
  set_property PROGRAM.VERIFY  1 [ get_property PROGRAM.HW_CFGMEM [lindex [get_hw_devices xc7s25_0] 0]]
  set_property PROGRAM.CHECKSUM  0 [ get_property PROGRAM.HW_CFGMEM [lindex [get_hw_devices xc7s25_0] 0]]
  startgroup 
  create_hw_bitstream -hw_device [lindex [get_hw_devices xc7s25_0] 0] [get_property PROGRAM.HW_CFGMEM_BITFILE [ lindex [get_hw_devices xc7s25_0] 0]]; program_hw_devices [lindex [get_hw_devices xc7s25_0] 0]; refresh_hw_device [lindex [get_hw_devices xc7s25_0] 0];
  program_hw_cfgmem -hw_cfgmem [ get_property PROGRAM.HW_CFGMEM [lindex [get_hw_devices xc7s25_0] 0]]

  boot_hw_device  [lindex [get_hw_devices xc7s25_0] 0]

  puts ">>>>>>>>>> Loaded into flash $flshfile"
}

quit
